//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4
import QtQuick.Controls 1.2 as QuickControls

import wesual.Controls 1.0

QuickControls.BusyIndicator {
    id : loadIndicator

    property bool  shown : false
    property color color : UI.color(UI.LoadIndicator)

    width   : 80
    height  : 80
    running : shown
    opacity : shown ? 1 : 0

    layer {
        enabled : true
        format  : ShaderEffectSource.RGBA
        effect  : ShaderEffect {
            readonly property color tint : loadIndicator.color

            fragmentShader: "
                uniform lowp sampler2D source;
                uniform lowp vec4      tint;
                uniform lowp float     qt_Opacity;

                varying highp vec2     qt_TexCoord0;

                void main() {
                    lowp vec4 p  = texture2D(source, qt_TexCoord0);
                    p.rgb *= p.a;
                    gl_FragColor = vec4(tint.rgb, 1.0) * p.a * qt_Opacity;
                }"
        }
    }

    Behavior on opacity {
        NumberAnimation { duration : 150 }
    }
}
